﻿USE VoxcoSystem
GO
---
--- sp_TerminateAgentSession
---
	
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_TerminateAgentSession]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_TerminateAgentSession]
GO

DECLARE @version varchar(128), @majorversion int
SET @version = CAST(SERVERPROPERTY('productversion') as varchar(128))
SET @majorversion = SUBSTRING(@version,1,CHARINDEX('.',@version,0)-1)
IF @majorversion >= 10 AND NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_TerminateAgentSession]') AND type in (N'P', N'PC'))
	BEGIN
		--MERGE is only supported on SQL2008 and above
		EXEC dbo.sp_executesql @statement = N'

		CREATE PROCEDURE [dbo].[sp_TerminateAgentSession]
		 @sessionId int,
		 @pauseTime int,
		 @logoutDateTime datetime = null
		AS

		IF @logoutDateTime IS NULL
			SET @logoutDateTime = GETUTCDATE()
		
		UPDATE  AgentSession 
		SET logoutDateTime = @logoutDateTime 
		WHERE sessionId = @sessionId
		
		MERGE AgentSessionConnectionTimes as target
		USING (SELECT @sessionId, @pauseTime) as source (sessionId, pauseTime)
		ON (target.sessionId = source.sessionId)
		WHEN MATCHED THEN
			UPDATE SET pauseTime = target.pauseTime + source.pauseTime
		WHEN NOT MATCHED THEN
			INSERT (sessionId,
					talkTime,
					waitingTime,
					pauseTime,
					reviewTime) 
			VALUES( source.sessionId,
					0,
					0,
					source.pauseTime,
					0);
		' 
	END
ELSE
	BEGIN
		--We are still using UPDATE for SQL2005 and below
		EXEC dbo.sp_executesql @statement = N'
		CREATE PROCEDURE [dbo].[sp_TerminateAgentSession]
		 @sessionId int,
		 @pauseTime int,
		 @logoutDateTime datetime = null
		AS

		IF @logoutDateTime IS NULL
			SET @logoutDateTime = GETUTCDATE()
		
		UPDATE  AgentSession 
		SET logoutDateTime = @logoutDateTime
		WHERE sessionId = @sessionId
		
		UPDATE  AgentSessionConnectionTimes
		SET pauseTime = pauseTime + @pauseTime
		WHERE sessionId = @sessionId 
		IF @@ROWCOUNT = 0
			INSERT INTO AgentSessionConnectionTimes 
			VALUES( @sessionId,
					0,
					0,
					@pauseTime,
					0)
		'
	END
GO
